/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemList;
import DE.siemens.ad.logo.model.SpecialBlock;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Memory;
import DE.siemens.ad.pdraw.action.EditBlockPropertiesAction;
import DE.siemens.ad.pdraw.simulation.OnlineTestTool;
import DE.siemens.ad.udf.UDFBlock;
import DE.siemens.ad.udf.UDFBlockParameter;
import java.util.HashMap;

public class RemoteChangeParamAction
extends EditBlockPropertiesAction {
    private static final long serialVersionUID = -4653552045886365667L;

    public RemoteChangeParamAction() {
        this.putValue("Name", "RemoteParam");
        this.putValue("textKey", "edit.RemoteParam");
        this.putValue("SmallIcon", this.getPlaceholder());
        this.disabledContextVector = null;
    }

    public void changeContext(Class contextClass) {
        if (contextClass == OnlineTestTool.class) {
            this.setActivated(true);
            this.setActivatedInCurrentContext(true);
        } else {
            this.setActivated(false);
            this.setActivatedInCurrentContext(false);
        }
    }

    public boolean prepareAction() {
        return super.prepareAction() && (this.fBlock instanceof SpecialBlock || this.fBlock instanceof UDFBlock);
    }

    public void editBlockProperties(Block block) {
        WiringDiagram wd = block.getWiringDiagram();
        int oldChecksum = ((Logo)wd.getHardware()).getChecksum(wd);
        String oldParaText = block.getParameter().getParameterText();
        HashMap<Block, Memory> blockMemoryMap = new HashMap<Block, Memory>();
        if (block instanceof UDFBlock) {
            UDFBlockParameter UDFParameter = (UDFBlockParameter)block.getParameter();
            ParameterItemList exposedUDFParameters = UDFParameter.getExposedParameterItems();
            for (int i = 0; i < exposedUDFParameters.size(); ++i) {
                Block rootBlock = ((ParameterItem)exposedUDFParameters.get(i)).getParameter().getBlock();
                blockMemoryMap.put(rootBlock, wd.getProgBytes(rootBlock));
            }
        } else {
            blockMemoryMap.put(block, wd.getProgBytes(block));
        }
        super.editBlockProperties(block);
        int newChecksum = ((Logo)wd.getHardware()).getChecksum(wd);
        String newParaText = block.getParameter().getParameterText();
        if (oldChecksum != newChecksum || !oldParaText.equals(newParaText)) {
            for (Block blk : blockMemoryMap.keySet()) {
                Memory memory = (Memory)blockMemoryMap.get(blk);
                wd.recordChangedBlock(blk, memory);
            }
        }
    }
}

